<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
if ( ! class_exists( 'MTS_Testimonials_Admin' ) ) :

class MTS_Testimonials_Admin {

	public $message;

	function __construct() {
		$this->settings = $this->get_settings();

		$this->verify_settings();

		add_action( 'init', array( $this, 'init' ), 10 );
	}

	function init() {
		$this->process_forms();

		add_action( 'admin_menu', array( $this, 'menu' ) );
		add_filter( 'add_menu_classes', array( $this, 'show_pending_number' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
		add_action( 'save_post', array( $this, 'save_post' ) );
		add_action( 'add_meta_boxes', array( $this, 'custom_fields_meta_box' ) );
		add_filter( 'manage_edit-mts_testimonials_columns', array( $this, 'admin_columns' ) ) ;
		add_action( 'manage_mts_testimonials_posts_custom_column', array( $this, 'admin_column_content' ), 10, 2 );
	}

	/*
     * Process settings forms
     */
	function process_forms() {
		// Process general settings page
		if ( isset( $_POST['mts_save_general_settings'] ) && check_admin_referer( 'mts_testimonial_general_page_action', 'mts_testimonial_general_page_nonce' ) ) {

			$this->settings['general']['moderate_testimonials'] = intval( @$_POST['moderate_testimonials'] );
			$this->settings['general']['max_image_size'] = intval( @$_POST['max_image_size'] );
			$this->settings['general']['submit_category'] = intval( @$_POST['submit_category'] );
			$this->settings['general']['default_image'] = @$_POST['default_image'];

			$this->save_settings();

			$this->message['update'][] = __( 'Your settings have been saved.', 'mts-testimonials' );
		}

		// Process forms settings page
		if ( isset( $_POST['mts_save_forms_settings'] ) && check_admin_referer( 'mts_testimonial_forms_page_action', 'mts_testimonial_forms_page_nonce' ) ) {
			// Checkboxes
			$this->settings['forms']['testimonial_form']['title_field_checkbox'] =  intval( @$_POST['title_field_checkbox'] );
			$this->settings['forms']['testimonial_form']['name_field_checkbox'] =  intval( @$_POST['name_field_checkbox'] );
			$this->settings['forms']['testimonial_form']['position_checkbox'] =  intval( @$_POST['position_checkbox'] );
			$this->settings['forms']['testimonial_form']['link_field_checkbox'] =  intval( @$_POST['link_field_checkbox'] );
			$this->settings['forms']['testimonial_form']['email_field_checkbox'] =  intval( @$_POST['email_field_checkbox'] );
			$this->settings['forms']['testimonial_form']['image_field_checkbox'] =  intval( @$_POST['image_field_checkbox'] );
			$this->settings['forms']['testimonial_form']['rating_field_checkbox'] =  intval( @$_POST['rating_field_checkbox'] );
			$this->settings['forms']['testimonial_form']['testimonial_field_checkbox'] =  intval( @$_POST['testimonial_field_checkbox'] );

			// Labels
			$this->settings['forms']['testimonial_form']['title_field_label'] =  esc_attr( $_POST['title_field_label'] );
			$this->settings['forms']['testimonial_form']['name_field_label'] =  esc_attr( $_POST['name_field_label'] );
			$this->settings['forms']['testimonial_form']['position_field_label'] =  esc_attr( $_POST['position_field_label'] );
			$this->settings['forms']['testimonial_form']['link_field_label'] =  esc_attr( $_POST['link_field_label'] );
			$this->settings['forms']['testimonial_form']['email_field_label'] =  esc_attr( $_POST['email_field_label'] );
			$this->settings['forms']['testimonial_form']['image_field_label'] =  esc_attr( $_POST['image_field_label'] );
			$this->settings['forms']['testimonial_form']['rating_field_label'] =  esc_attr( $_POST['rating_field_label'] );
			$this->settings['forms']['testimonial_form']['testimonial_field_label'] =  esc_attr( $_POST['testimonial_field_label'] );
			$this->settings['forms']['testimonial_form']['submit_label'] =  esc_attr( $_POST['submit_label'] );

			// Messages
			$this->settings['forms']['testimonial_form']['success_message'] =  esc_attr( $_POST['success_message'] );
			$this->settings['forms']['testimonial_form']['error_message'] =  esc_attr( $_POST['error_message'] );

			$this->save_settings();

			$this->message['update'][] = __( 'Your settings have been saved.', 'mts-testimonials' );
		}
	}

	/**
	 * Updates testimonial meta data
	 *
     * @param integer $post_id
     */
	function save_post( $post_id ) {
		/*if ( isset( $_POST['title'] ) ) {
			$args['title'] = esc_attr( $_POST['title'] );

			update_post_meta( $post_id, 'testimonial_title', $args['title'] );
		}*/

		if ( isset( $_POST['person_name'] ) ) {
			$args['name'] = esc_attr( $_POST['person_name'] );

			update_post_meta( $post_id, 'testimonial_name', $args['name'] );
		}

		if ( isset( $_POST['position'] ) ) {
			$args['position'] = esc_attr( $_POST['position'] );

			update_post_meta( $post_id, 'testimonial_position', $args['position'] );
		}

		if ( isset( $_POST['link'] ) ) {
			$args['link'] = esc_url( $_POST['link'] );

			update_post_meta( $post_id, 'testimonial_link', $args['link'] );
		}

		if ( isset( $_POST['email'] ) ) {
			$args['email'] = esc_attr( $_POST['email'] );

			update_post_meta( $post_id, 'testimonial_email', $args['email'] );
		}

		if ( isset( $_POST['image'] ) ) {
			$args['image'] = esc_attr( $_POST['image'] );

			update_post_meta( $post_id, 'testimonial_image', $args['image'] );
		}

		if ( isset( $_POST['rating'] ) ) {
			$args['rating'] = (int) $_POST['rating'];

			update_post_meta( $post_id, 'testimonial_rating', $args['rating'] );
		}
	}

	/**
     * Adds meta box for testimonial custom fields
     */
	function custom_fields_meta_box() {
		add_meta_box( 'mts_testimonials_metabox', __( 'Testimonial Fields', 'mts-testimonials' ), array( $this, 'custom_fields_meta_box_callback' ), 'mts_testimonials', 'normal', 'high' );
	}

	/**
     * Testimonial Fields meta box callback
     */
	function custom_fields_meta_box_callback() {
		global $post, $mts_testimonials;

		$settings = mts_testimonials_get_settings();

		// Setup testimonial arguments
		$name = get_post_meta( $post->ID, 'testimonial_name', true );
		$position = get_post_meta( $post->ID, 'testimonial_position', true );
		$link = get_post_meta( $post->ID, 'testimonial_link', true );
		$email = get_post_meta( $post->ID, 'testimonial_email', true );
		$image = get_post_meta( $post->ID, 'testimonial_image', true );
		$rating = get_post_meta( $post->ID, 'testimonial_rating', true );

		$output = '<div id="mts-testimonials-cf-meta-box">';

			$output .= "<label for=\"name\">". $settings['forms']['testimonial_form']['name_field_label'] ."</label><br />";
			$output .= "<input type=\"text\" name=\"person_name\" id=\"name\" value=\"". $name ."\"><br />";

			$output .= "<label for=\"position\">". $settings['forms']['testimonial_form']['position_field_label'] ."</label><br />";
			$output .= "<input type=\"text\" name=\"position\" id=\"position\" value=\"". $position ."\"><br />";

			$output .= "<label for=\"link\">". $settings['forms']['testimonial_form']['link_field_label'] ."</label><br />";
			$output .= "<input type=\"text\" name=\"link\" id=\"link\" value=\"". $link ."\"><br />";

			$output .= "<label for=\"email\">". $settings['forms']['testimonial_form']['email_field_label'] ."</label><br />";
			$output .= "<input type=\"text\" name=\"email\" id=\"email\" value=\"". $email ."\"><br />";

			$output .= "<div class=\"testimonial-user-image\"<label for=\"image\">". $settings['forms']['testimonial_form']['image_field_label'] ."</label><br />";
			$output .= "<input type=\"text\" name=\"image\" id=\"image\" value=\"" . $image . "\" /></div><br />";

			$output .= "<label for=\"rating\">". $settings['forms']['testimonial_form']['rating_field_label'] ."</label><br />";
			$output .= $mts_testimonials->stars_input('rating', $rating, 'mts-testimonial-metabox-rating');

		$output .= "</div>";

		echo $output;
	}

	/**
     * Get settings
	 *
     * @param string $saved
     */
    function get_settings( $saved = true ) {
        if ( $saved == true )
            $this->settings = get_option( 'mts_testimonials_settings' );

        return $this->settings;
    }

    /**
     * Get setting
	 *
     * @param string $param1
     * @param string $param2
     * @param string $param3
     */
    function get_setting( $param1 = '', $param2 = '', $param3 = '' ) {
        $settings = $this->get_settings();

        if ( $param1 ) {
            $setting = @$settings[$param1];
        }

        if ( $param1 && $param2 ) {
            $setting = @$settings[$param1][$param2];
        }

        if ( $param1 && $param2 && $param3 ) {
            $setting = @$settings[$param1][$param2][$param3];
        }

        return $setting;
    }

    /*
     * Save settings
     */
    function save_settings() {
        $save = update_option( 'mts_testimonials_settings', $this->settings );

		return true;
    }

    /*
     * Delete settings
     */
    function delete_settings( $array, $array2 = null ) {
        if ( !$array2 ) {
            unset( $this->settings[$array] );
        } else {
            unset( $this->settings[$array][$array2] );
        }

        $this->save_settings();
    }

    /*
     * Delete settings option
     */
    function delete_settings_option() {
        delete_option( 'mts_testimonials_settings' );
    }

    /*
     * Verify settings
     */
    function verify_settings() {
        $update_settings = false;

        $default_settings = array(
			'version' => MTS_TESTIMONIALS_VERSION,
            'general' => array(
                 'moderate_testimonials' => 1,
                 'max_image_size' => 2,
                 'default_image' => MTS_TESTIMONIALS_URL.'/assets/img/user.png',
                 'submit_category' => 0
                ),
			'forms' => array(
				'testimonial_form' => array(
					 'title_field_checkbox' => 1,
					 'name_field_checkbox' => 1,
					 'position_checkbox' => 1,
					 'link_field_checkbox' => 1,
					 'email_field_checkbox' => 1,
					 'image_field_checkbox' => 1,
					 'rating_field_checkbox' => 1,
					 'testimonial_field_checkbox' => 1,
					 'title_field_label' => __('Title', 'mts-testimonials'),
					 'name_field_label' => __('Name', 'mts-testimonials'),
					 'position_field_label' => __('Position of the person', 'mts-testimonials'),
					 'link_field_label' => __('Link', 'mts-testimonials'),
					 'email_field_label' => __('Email', 'mts-testimonials'),
					 'image_field_label' => __('Image - [Recommended Size: 75x75]', 'mts-testimonials'),
					 'rating_field_label' => __('Rating', 'mts-testimonials'),
					 'testimonial_field_label' => __('Testimonial', 'mts-testimonials'),
					 'submit_label' => __('Send', 'mts-testimonials'),
					 'success_message' => __('Thank you for your feedback!', 'mts-testimonials'),
					 'error_message' => __('Please fill in all fields')
				 )
			)
		);

        foreach ( $default_settings as $element_settings => $settings ) {
            if ( is_array( $settings ) ) {
                foreach ( $settings as $element => $value ) {
                    if ( !isset( $this->settings[$element_settings][$element] ) ) {
                        $this->settings[$element_settings][$element] = $value;
                        $update_settings                             = true;
                    }
                }
            } else {
                if ( !isset( $this->settings[$element_settings] ) ) {
                    $this->settings[$element_settings] = $settings;
                    $update_settings                   = true;
                }
            }

            if ( $update_settings == true )
                $this->save_settings();
        }
    }

	/*
     * Get messages for admin pages
     */
	function get_messages() {
        if ( !empty( $this->message ) ) {
            $messages = '';

            if ( !empty( $this->message['update'] ) ) {
                foreach ( $this->message['update'] as $message ) {
                    $messages .= $message . "<br /> \r\n";
                }

                $output = '<div class="updated"><p><strong>' . $messages . '</strong></p></div>';

                return $output;
            } else if ( !empty( $this->message['error'] ) ) {
                foreach ( $this->message['error'] as $message ) {
                    $messages .= $message . "<br /> \r\n";
                }

                $output = '<div class="error"><p><strong>' . $messages . '</strong></p></div>';

                return $output;
            }
        }
    }

    /*
     * Output messages
     */
    function messages_html() {
        echo $this->get_messages();
    }

	/*
     * Menu
     */
	function menu() {
		add_submenu_page( 'edit.php?post_type=mts_testimonials', __( 'Shortcodes', 'mts-testimonials' ), __( 'Shortcodes', 'mts-testimonials' ), 'manage_options', 'mts_testimonials_shortcodes', array( $this, 'settings_shortcodes_content' ), null );
        add_submenu_page( 'edit.php?post_type=mts_testimonials', __( 'General', 'mts-testimonials' ), __( 'Settings', 'mts-testimonials' ), 'manage_options', 'mts_testimonials', array( $this, 'settings_general_content' ), null );
		add_submenu_page( null, __( 'Forms', 'mts-testimonials' ), __( 'Forms', 'mts-testimonials' ), 'manage_options', 'mts_testimonials_forms', array( $this, 'settings_forms_content' ), null );
	}

	function show_pending_number( $menu ) {
	    $type = "mts_testimonials";
	    $status = "draft";
	    $num_posts = wp_count_posts( $type, 'readable' );
	    $pending_count = 0;
	    if ( !empty($num_posts->$status) )
	        $pending_count = $num_posts->$status;

	    // build string to match in $menu array
	    if ($type == 'post') {
	        $menu_str = 'edit.php';
	    } else {
	        $menu_str = 'edit.php?post_type=' . $type;
	    }

	    // loop through $menu items, find match, add indicator
	    foreach( $menu as $menu_key => $menu_data ) {
	        if( $menu_str != $menu_data[2] )
	            continue;
	        $menu[$menu_key][0] .= " <span class='update-plugins count-$pending_count'><span class='plugin-count'>" . number_format_i18n($pending_count) . '</span></span>';
	    }
	    return $menu;
	}

	/*
     * General settings page
     */
	function settings_general_content() {
		include( MTS_TESTIMONIALS_ADMIN_PATH . '/interface/general.php' );
	}

	/*
     * Forms settings page
     */
	function settings_forms_content() {
		include( MTS_TESTIMONIALS_ADMIN_PATH . '/interface/forms.php' );
	}

	/*
     * Shortcodes settings page
     */
	function settings_shortcodes_content() {
		include( MTS_TESTIMONIALS_ADMIN_PATH . '/interface/shortcodes.php' );
	}

	/*
     * Settings tabs HTML
     */
	function settings_page_tabs_html() {
		$general_active  = ( basename( $_GET['page'] ) == 'mts_testimonials' ) ? 'nav-tab-active' : '';
		$forms_active    = ( basename( $_GET['page'] ) == 'mts_testimonials_forms' ) ? 'nav-tab-active' : '';
		$shortcodes_active    = ( basename( $_GET['page'] ) == 'mts_testimonials_shortcodes' ) ? 'nav-tab-active' : '';

        $html = '<h2 class="nav-tab-wrapper" id="mts-settings-tabs">' . "\r\n";
        $html .= '<a class="nav-tab ' . $general_active . '" id="mts-settings-general-tab" href="' . admin_url( 'edit.php?post_type=mts_testimonials&page=mts_testimonials' ) . '">' . __( 'General Settings', 'mts-testimonials' ) . '</a>' . "\r\n";
        $html .= '<a class="nav-tab ' . $forms_active . '" id="mts-settings-style-tab" href="' . admin_url( 'edit.php?post_type=mts_testimonials&page=mts_testimonials_forms' ) . '">' . __( 'Submission Form', 'mts-testimonials' ) . '</a>' . "\r\n";
		$html .= '<a class="nav-tab ' . $shortcodes_active . '" id="mts-settings-style-tab" href="' . admin_url( 'edit.php?post_type=mts_testimonials&page=mts_testimonials_shortcodes' ) . '">' . __( 'Shortcode Generator', 'mts-testimonials' ) . '</a>' . "\r\n";
        $html .= '</h2>' . "\r\n";

        echo $html;
    }

	/**
	 * Enqueues scripts for admin
     */
	function enqueue_scripts() {
		global $post;

		$screen = get_current_screen();
		if ( isset($screen->post_type) && $screen->post_type == 'mts_testimonials' && $screen->id != 'mts_testimonials_page_mts_testimonials_shortcodes' ) {
			wp_register_style( 'mts_testimonials_admin', MTS_TESTIMONIALS_URL . '/assets/css/admin.css', false );
			wp_enqueue_style( 'mts_testimonials_admin' );
			wp_enqueue_style( 'mts-testimonials', MTS_TESTIMONIALS_URL . '/assets/css/testimonial.css' );

			wp_enqueue_script( 'mts_testimonials_admin', MTS_TESTIMONIALS_URL . '/assets/js/admin.js', array( 'jquery' ), MTS_TESTIMONIALS_VERSION, false );
			wp_enqueue_script( 'mts_testimonials', MTS_TESTIMONIALS_URL . '/assets/js/testimonial.js' );
			wp_enqueue_media();
			wp_enqueue_script( 'mts_wp_media_uploader', MTS_TESTIMONIALS_URL . '/assets/js/wp-media-uploader.js', array('jquery') );
		} else if ($screen->id == 'mts_testimonials_page_mts_testimonials_shortcodes') {
			wp_enqueue_style( 'wp-color-picker' );
    		wp_enqueue_script( 'wp-color-picker');

			wp_enqueue_style( 'selectize', MTS_TESTIMONIALS_URL . '/assets/css/selectize.css' );
			wp_enqueue_script( 'selectize', MTS_TESTIMONIALS_URL . '/assets/js/selectize.js', array( 'jquery' ) );

			wp_enqueue_style( 'mts_testimonials_shortcode_generator', MTS_TESTIMONIALS_URL . '/assets/css/shortcode-generator.css', false );
			wp_enqueue_style( 'mts-testimonials', MTS_TESTIMONIALS_URL . '/assets/css/testimonial.css' );
			wp_enqueue_style('jquery-ui-lightness', 'http://ajax.googleapis.com/ajax/libs/jqueryui/1.8.21/themes/ui-lightness/jquery-ui.css');

			wp_enqueue_style( 'mts-owl-carousel', MTS_TESTIMONIALS_URL . '/assets/css/mtswpt.owl.carousel.css' );
			wp_enqueue_script( 'mts-owl-carousel', MTS_TESTIMONIALS_URL . '/assets/js/owl.carousel.min.js', array( 'jquery' ) );

			wp_enqueue_script( 'mts_testimonials_shortcode_generator', MTS_TESTIMONIALS_URL . '/assets/js/shortcode-generator.js', array('jquery-ui-core', 'jquery-ui-resizable') );

		}
	}

	function admin_columns( $columns ) {
		// recreate the array to insert columns in correct position
		$new_columns = array();
		foreach ($columns as $column => $col_label) {
			if ($column == 'date') {
				$new_columns['name'] = __('Name', 'mts-testimonials');
				$new_columns['rating'] = __('Rating', 'mts-testimonials');
			}
			$new_columns[$column] = $col_label;
		}

		return $new_columns;
	}

	function admin_column_content( $column, $post_id ) {
		global $post, $mts_testimonials;

		switch ($column) {
			case 'name':
				echo get_post_meta( $post_id, 'testimonial_name', true);
			break;

			case 'rating':
				echo $mts_testimonials->stars_input('mts-testimonial-rating', get_post_meta( $post_id, 'testimonial_rating', true), null, '', true );
			break;

			default:
				// stop, just stop
			break;
		}
	}
}

endif;
